# H 指数

<p>给你一个整数数组 <code>citations</code> ，其中 <code>citations[i]</code> 表示研究者的第 <code>i</code> 篇论文被引用的次数。计算并返回该研究者的 <strong><code>h</code><em> </em>指数</strong>。</p>

<p><a href="https://baike.baidu.com/item/h-index/3991452?fr=aladdin" target="_blank">h 指数的定义</a>：h 代表“高引用次数”（high citations），一名科研人员的 h 指数是指他（她）的 （<code>n</code> 篇论文中）<strong>总共</strong>有 <code>h</code> 篇论文分别被引用了<strong>至少</strong> <code>h</code> 次。且其余的 <em><code>n - h</code> </em>篇论文每篇被引用次数 <strong>不超过 </strong><em><code>h</code> </em>次。</p>

<p>例如：某人的 h 指数是 20，这表示他已发表的论文中，每篇被引用了至少 20 次的论文总共有 20 篇。</p>

<p><strong>提示：</strong>如果 <code>h</code><em> </em>有多种可能的值，<strong><code>h</code> 指数 </strong>是其中最大的那个。</p>

<p> </p>

<p><strong>示例 1：</strong></p>

<pre>
<strong>输入：</strong><code>citations = [3,0,6,1,5]</code>
<strong>输出：</strong>3 
<strong>解释：</strong>给定数组表示研究者总共有 <code>5</code> 篇论文，每篇论文相应的被引用了 <code>3, 0, 6, 1, 5</code> 次。
     由于研究者有 <code>3 </code>篇论文每篇 <strong>至少 </strong>被引用了 <code>3</code> 次，其余两篇论文每篇被引用 <strong>不多于</strong> <code>3</code> 次，所以她的 <em>h </em>指数是 <code>3</code>。</pre>

<p><strong>示例 2：</strong></p>

<pre>
<strong>输入：</strong>citations = [1,3,1]
<strong>输出：</strong>1
</pre>

<p> </p>

<p><strong>提示：</strong></p>

<ul>
	<li><code>n == citations.length</code></li>
	<li><code>1 <= n <= 5000</code></li>
	<li><code>0 <= citations[i] <= 1000</code></li>
</ul>

<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp
int main()
{
    Solution sol;
    vector<int> citations = {3, 0, 6, 1, 5};
    int res;
    res = sol.hIndex(citations);
    cout << res;
    return 0;
}
```

## 答案

```cpp
class Solution
{
public:
    int hIndex(vector<int> &citations)
    {
        if (citations.empty())
            return 0;
        int max_cite = citations[0];
        int n = citations.size();
        for (auto x : citations)
            if (x > max_cite)
                max_cite = x;
        vector<int> count(max_cite + 1, 0);
        for (auto x : citations)
            count[x]++;
        for (int i = 1; i <= max_cite; i++)
            count[i] = count[i - 1];
        int h_index = 0;
        for (int i = 1; i <= max_cite; i++)
            if ((n - count[i - 1]) >= i && count[i] >= n - i)
                h_index = i;
        return h_index;
    }
};
```
## 选项


### A

```cpp
class Solution
{
public:
    int hIndex(vector<int> &citations)
    {
        sort(citations.begin(), citations.end());
        int h = 0;
        auto iter = citations.rbegin();
        while (iter != citations.rend())
        {
            h++;
            if (*iter < h)
                return h - 1;
            iter++;
        }
        return h;
    }
};
```

### B

```cpp
class Solution
{
public:
    int hIndex(vector<int> &citations)
    {
        int citationSize = citations.size();
        if (citationSize < 1)
            return 0;
        vector<int> record(citationSize + 1, 0);
        for (int i = 0; i < citationSize; ++i)
        {
            if (citations[i] <= citationSize)
                ++record[citations[i]];
            else
                ++record[citationSize];
        }

        for (int j = citationSize, paperNum = 0; j >= 0; --j)
        {
            paperNum += record[j];
            if (paperNum >= j)
                return j;
        }
        return 0;
    }
};
```

### C

```cpp
class Solution
{
public:
    int hIndex(vector<int> &citations)
    {
        sort(citations.begin(), citations.end(), [](const int &a, const int &b)
             { return a > b; });
        int i = 0;
        for (; i < citations.size(); ++i)
            if (citations[i] <= i)
                break;
        return i;
    }
};
```
